% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNode.R
\docType{methods}
\name{generateIdentifier}
\alias{enerateIdentifier}
\alias{generateIdentifier}
\alias{generateIdentifier,MNode-method}
\title{Get a unique identifier that is generated by the Member Node repository and guaranteed to be unique.}
\usage{
generateIdentifier(x, ...)

\S4method{generateIdentifier}{MNode}(x, scheme = "UUID", fragment = NULL)
}
\arguments{
\item{x}{The MNode instance on which the object will be created}

\item{...}{(Not yet used.)}

\item{scheme}{The identifier scheme to be used, such as DOI, UUID, etc.}

\item{fragment}{An optional fragment to be prepended to the identifier for schemes that support it (not all do).}
}
\value{
the character string of the generated unique identifier
}
\description{
Creating objects requires use of a unique persistent identifier (pid) when calling the create
function.  Member Nodes may optionally provide the generateIdentifier service to issue such identifiers, 
ensuring that they are unique. Each identifier conforms to an identifier scheme, which determines the syntax and
rules for how the identifier that is generated is formatted.  All Member Nodes that implement this method must 
support the UUID scheme, but may also support other schemes such as DOI and others.
}
\details{
In the version 2.0 library and higher, this operation can utilize an 
'dataone_token' option to provide credentials for write operations in DataONE.
The authentication token is obtained from DataONE (see your profile on https://search.dataone.org).
See the \code{vignette("dataone-overview")} for details.
Alternatively, the version 1.0 approach of using an X.509 certificate in a default location of the file 
system can also be used. This certificate provides authentication credentials from 
CILogon \url{https://cilogon.org/?skin=DataONE}.  See \code{vignette("dataone-overview")} for details.
}
\examples{
\dontrun{
library(dataone)
cn <- CNode("STAGING")
mn <- getMNode(cn, "urn:node:mnStageUCSB2")
newid <- generateIdentifier(mn, "UUID")
}
}
\seealso{
\url{https://purl.dataone.org/architecture/apis/MN_APIs.html#MNStorage.generateIdentifier}
}

