% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNode.R
\docType{methods}
\name{isAuthorized}
\alias{isAuthorized}
\alias{isAuthorized,CNode-method}
\title{Check if an action is authorized for the specified identifier}
\usage{
isAuthorized(x, ...)

\S4method{isAuthorized}{CNode}(x, id, action)
}
\arguments{
\item{x}{The node to send the request to.}

\item{...}{(Not yet used)}

\item{id}{The DataONE identifier (pid or sid) to check access for.}

\item{action}{The DataONE action to check, possible values: "read", "write", "changePermission"}
}
\value{
a logical, TRUE if the action is authorized, false if not.
}
\description{
Test if the user identified by the provided token has 
authorization for operation on the specified object.
}
\details{
The identifer parameter may be either a DataONE persistant identifier (pid)
or series identifier (sid).
}
\examples{
\dontrun{
cn <- CNode("STAGING")
isAuthorized(cn, "doi:10.5072/FK2/LTER/sbclter.842.1", "read")
isAuthorized(cn, "doi:10.5072/FK2/LTER/sbclter.842.1", "write")
isAuthorized(cn, "doi:10.5072/FK2/LTER/sbclter.842.1", "changePermission")
}
}
\seealso{
\code{\link[=CNode-class]{CNode}}{ class description.}
}

