% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R
\docType{methods}
\name{getQueryEngineDescription}
\alias{getQueryEngineDescription}
\alias{getQueryEngineDescription,D1Node-method}
\title{Query a node for the list of query engines available on the node}
\usage{
getQueryEngineDescription(x, ...)

\S4method{getQueryEngineDescription}{D1Node}(x, queryEngineName)
}
\arguments{
\item{x}{The CNode or MNode to query}

\item{...}{(Additional arguments - not yet used.)}

\item{queryEngineName}{The query engine name to get a description for.}
}
\value{
list The query engine description
}
\description{
Query a node for the list of query engines available on the node
}
\examples{
\dontrun{
library(dataone)
cn <- CNode("PROD")
engineDesc <- getQueryEngineDescription(cn, "solr")
cat(sprintf("Query engine version: \%s\\n", engineDesc$queryEngineVersion))
cat(sprintf("Query engine name: \%s\\n", engineDesc$name))
engineDesc <- getQueryEngineDescription(cn, "solr")
head(engineDesc$queryFields, n=3L)
}
}
