% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_min_obs_level.R
\name{prep_min_obs_level}
\alias{prep_min_obs_level}
\title{Support function to identify the levels of a process variable with minimum
number of observations}
\usage{
prep_min_obs_level(study_data, group_vars, min_obs_in_subgroup)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{group_vars}{\link{variable list} the name grouping variable}

\item{min_obs_in_subgroup}{\link{integer} optional argument if a "group_var" is
used. This argument specifies the
minimum no. of observations that is
required to include a subgroup (level)
of the "group_var" in the analysis.
Subgroups with less observations are
excluded. The default is 30.}
}
\value{
a data frame with:
\itemize{
\item a subsample of original data
}
}
\description{
utility function to subset data based on minimum number of observation per
level
}
\details{
This functions removes observations having less than \code{min_obs_in_subgroup}
distinct values in a group variable, e.g. blood pressure measurements
performed by an examiner having less than e.g. 50 measurements done. It
displays a warning, if samples/rows are removed and returns the modified
study data frame.
}
