% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_segment_missingness.R
\name{com_segment_missingness}
\alias{com_segment_missingness}
\title{Summarizes missingness for individuals in specific segments}
\usage{
com_segment_missingness(
  study_data,
  meta_data,
  group_vars = NULL,
  strata_vars = NULL,
  label_col,
  threshold_value,
  direction,
  exclude_roles = "process"
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{group_vars}{\link{variable} the name of a variable used for grouping,
defaults to \emph{NULL} for not grouping output}

\item{strata_vars}{\link{variable} the name of a variable used for stratification,
defaults to NULL for not grouping output}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{threshold_value}{\link{numeric} from=0 to=100. a numerical value ranging
from 0-100}

\item{direction}{\link{enum} low | high. "high" or "low", i.e. are deviations
above/below the threshold critical}

\item{exclude_roles}{\link{variable roles} a character (vector) of variable roles
not included}
}
\value{
a list with:
\itemize{
\item \code{SummaryData}: data frame about segment missingness
\item \code{SummaryPlot}: ggplot2 heatmap plot: a heatmap-like graphic that
highlights critical values depending on the respective
threshold_value and direction.
}
}
\description{
\subsection{This implementation can be applied in two use cases:}{
\enumerate{
\item participation in study segments is not recorded by respective variables,
e.g. a participant's refusal to attend a specific examination is not
recorded.
\item participation in study segments is recorded by respective
variables.
}

Use case \emph{(1)} will be common in smaller studies. For the calculation of
segment missingness it is assumed that study variables are nested in
respective segments. This structure must be specified in the static metadata.
The R-function identifies all variables within each segment and returns TRUE
if all variables within a segment are missing, otherwise FALSE.

Use case \emph{(2)} assumes a more complex structure of study data and meta data.
The study data comprise so-called intro-variables (either TRUE/FALSE or codes
for non-participation). The column KEY_STUDY_SEGMENT in the metadata is
filled by variable-IDs indicating for each variable the respective
intro-variable. This structure has the benefit that subsequent calculation of
item missingness obtains correct denominators for the calculation of
missingness rates.
}
}
\details{
\subsection{Implementation and use of thresholds}{

This implementation uses one threshold to discriminate critical from
non-critical values. If direction is high than all values below the
threshold_value are normal (displayed in dark blue in the plot and flagged
with grading = 0 in the dataframe). All values above the threshold_value are
considered critical. The more they deviate from the threshold the displayed
color shifts to dark red. All critical values are highlighted with grading =
1 in the summary data frame. By default, highest values are always shown in
dark red irrespective of the absolute deviation.

If direction is low than all values above the threshold_value are normal
(displayed in dark blue, grading = 0).
}

\subsection{Hint}{

This function does not support a \code{resp_vars} argument but \code{exclude_roles} to
specify variables not relevant for detecting a missing segment.

List function.
}
}
\seealso{
\href{https://dataquality.ship-med.uni-greifswald.de/VIN_com_impl_segment_missingness.html}{Online Documentation}
}
