% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeriesAccuracy.R
\name{GetSeriesAccuracy}
\alias{GetSeriesAccuracy}
\title{Get the computed series accuracy for a model, computing it if not already computed.}
\usage{
GetSeriesAccuracy(model, maxWait = 600)
}
\arguments{
\item{model}{character. The model for which you want to compute Feature Impact, e.g.
from the list of models returned by \code{ListModels(project)}.}

\item{maxWait}{integer. How long (in seconds) to wait for series accuracy computation
before raising a timeout error? Default 600.}
}
\value{
data.frame with items:
  \itemize{
    \item multiseriesId character. The ID of the series.
    \item rowCount integer. The number of rows in the series.
    \item multiseriesValues character. The name of the series.
    \item duration character. The duration of the series.
    \item validationScore numeric. The validation score for the series.
    \item backtestingScore numeric. The score on backtests for the series. See
      \code{ScoreBacktests}.
    \item holdoutScore numeric. The score for the series on the holdout set.
  }
}
\description{
Get the computed series accuracy for a model, computing it if not already computed.
}
\examples{
\dontrun{
  projectId <- "5984b4d7100d2b31c1166529"
  modelId <- "5984b4d7100d2b31c1166529"
  model <- GetModel(projectId, modelId)
  seriesAccuracy <- GetSeriesAccuracy(model)
}
}
