% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdvancedTuning.R
\name{GetTuningParameters}
\alias{GetTuningParameters}
\title{Retrieve data on tuning parameters for a particular model.}
\usage{
GetTuningParameters(model)
}
\arguments{
\item{model}{dataRobotModel. A DataRobot model object to get tuning parameters for.}
}
\value{
A list detailing the following about each tuning parameter:
\itemize{
  \item currentValue character. The current searched values of that parameter.
  \item defaultValue character. The default value of that parameter.
  \item parameterId character. A unique ID for that particular parameter.
  \item parameterName character. The name of the tuning parameter.
  \item taskName character. The name of the task the parameter is for.
  \item constraints list. A list describing constraints on the possible values for the parameter.
    Will be one of \code{int} or \code{float} specifying a \code{min} and \code{max} value, or
    will be \code{select} and will specify possible values from a list of choices. \code{int} and
    \code{float} correspond with integer and floating-point parameter spaces respectively. It is
    possible for a parameter to be multiple types. Lastly, some parameters will also have a
    \code{supportsGridSearch} logical for whether or not that parameter can be grid searched
    or not.
}
}
\description{
Retrieve data on tuning parameters for a particular model.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  GetTuningParameters(model)
}
}
