% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestSampleSizeUpdate.R
\name{RequestSampleSizeUpdate}
\alias{RequestSampleSizeUpdate}
\title{Refits an existing model to a different fraction of the training dataset}
\usage{
RequestSampleSizeUpdate(model, samplePct)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModelObject, or each element of the list returned by
the function GetAllModels.}

\item{samplePct}{Numeric, specifying the percentage of the training dataset
to be used in building the new model.}
}
\value{
Integer, value to be used as the modelJobId parameter in calling the
function GetModelFromJobId to retrieve the updated model.
}
\description{
This function requests a refit of the model defined by the model parameter
to the same training dataset used in building it originally, but with a
different fraction of the data, specified by the samplePct parameter.
The function returns an integer value that may be used with the function
GetModelFromJobId to retrieve the model after fitting is complete.
}
\details{
Motivation for this function is the fact that some models - e.g., very
complex machine learning models fit to large datasets - may take a long
time to complete.  Splitting the model creation request from model retrieval
in these cases allows the user to perform other interactive R session tasks
between the time the model creation/update request is made and the time the
final model is available.
}

