% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectToDataRobot.R
\name{ConnectToDataRobot}
\alias{ConnectToDataRobot}
\title{Establish a connection to the DataRobot modeling engine}
\usage{
ConnectToDataRobot(endpoint = NULL, token = NULL, username = NULL,
  password = NULL, configPath = NULL)
}
\arguments{
\item{endpoint}{character. URL specifying the DataRobot server to be used.
It depends on DataRobot modeling engine implementation (cloud-based, on-prem...) you are using.
Contact your DataRobot admin for endpoint to use and to turn on API access to your account.
The endpoint for DataRobot cloud accounts is https://app.datarobot.com/api/v2}

\item{token}{character. DataRobot API access token. It is unique for each DataRobot modeling
engine account and can be accessed using DataRobot webapp in Account profile section.}

\item{username}{character. No longer supported.}

\item{password}{character. No longer supported.}

\item{configPath}{character. Path to YAML config file specifying configuration
(token and endpoint).}
}
\description{
This function initializes a DataRobot session. If a (YAML) config file (with keys for endpoint
and token) is placed at $HOME/.config/datarobot/drconfig.yaml, then we
attempt to establish a connection to DataRobot when the package loads, so
(if successful) this function does not need to be called.
}
\details{
The function creates the environment variables "DataRobot_URL" and "DataRobot_Token" used by
other functions to access the DataRobot modeling engine.
}
\examples{
\dontrun{
  ConnectToDataRobot("https://app.datarobot.com/api/v2", "thisismyfaketoken")
  ConnectToDataRobot(configPath = "~/.config/datarobot/drconfig.yaml")
}
}
