% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publisher.R
\name{publisher}
\alias{publisher}
\alias{publisher<-}
\title{Get/set the Publisher of the object.}
\usage{
publisher(x)

publisher(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{An R object, such as a data.frame, a tibble, or a data.table.}

\item{overwrite}{If the attributes should be overwritten. In case it is set to \code{FALSE},
it gives a message with the current \code{Publisher} property instead of overwriting it.
Defaults to \code{TRUE} when the attribute is set to \code{value} regardless of previous
setting.}

\item{value}{The \code{Publisher} as a character set.}
}
\value{
The Publisher attribute as a character of length 1 is added to \code{x}.
}
\description{
Add the optional \code{Publisher} property as an attribute to an R object.
}
\details{
The \code{Publisher} corresponds to dct:publisher and Publisher in DataCite.
The name of the entity that holds, archives, publishes prints, distributes, releases,
issues, or produces the resource. This property will be used to formulate the citation,
so consider the prominence of the role. For software, use Publisher for the
code repository. If there is an entity other than a code repository, that
"holds, archives, publishes, prints, distributes, releases, issues, or produces" the
code, use the property Contributor/contributorType/ hostingInstitution for the code
repository.
}
\examples{
iris_dataset <- iris
publisher(iris_dataset) <- "American Iris Society"
publisher(iris_dataset)
}
\seealso{
Other Reference metadata functions: 
\code{\link{creator}()},
\code{\link{dataset_source}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{rights}()},
\code{\link{size}()},
\code{\link{version}()}
}
\concept{Reference metadata functions}
