% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publication_year.R
\name{publication_year}
\alias{publication_year}
\alias{publication_year<-}
\title{Get/set the publication_year of the object.}
\usage{
publication_year(x)

publication_year(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A semantically rich data frame object created by
\code{dataset::\link{dataset_df}} or \code{dataset::\link{as_dataset_df}}.}

\item{overwrite}{If the attributes should be overwritten. In case it is set
to \code{FALSE}, it gives a message with the current \code{PublicationYear}
property instead of overwriting it. Defaults to \code{TRUE} when the
attribute is set to \code{value} regardless of previous setting.}

\item{value}{The publication_year as a character set.}
}
\value{
Returns the \code{year} metadata field of the \code{DataBibentry} of
the dataset
}
\description{
Get/set the optional \code{publication_year} property as an
attribute to an R object.
}
\details{
The \code{PublicationYear} is the year when the data was or will be
made publicly available in \code{YYYY} format. See
\href{https://support.datacite.org/docs/datacite-metadata-schema-v44-mandatory-properties#publicationyearadditional-guidance}{Publication
Year: DataCite Additional Guidance}.
}
\examples{
publication_year(orange_df)
publication_year(orange_df) <- 1998
}
\seealso{
Other Reference metadata functions: 
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publisher}()},
\code{\link{rights}()}
}
\concept{Reference metadata functions}
