% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_file.R
\name{get_file}
\alias{get_file}
\alias{get_file_metadata}
\title{Download File(s)}
\usage{
get_file(file, dataset = NULL, format = c("original", "RData", "prep",
  "bundle"), vars = NULL, key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"), ...)

get_file_metadata(file, dataset = NULL, format = c("ddi", "preprocessed"),
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"), ...)
}
\arguments{
\item{file}{An integer specifying a file identifier; or, if \code{doi} is specified, a character string specifying a file name within the DOI-identified dataset; or an object of class \dQuote{dataverse_file} as returned by \code{\link{dataset_files}}.}

\item{dataset}{An integer specifying a dataset identification number or an object of class \dQuote{dataverse_dataset}. The identification number is the dataset's persistent identification number (not the integer specifying a specific version of the dataset, such as returned by \code{\link{dataset_versions}}).}

\item{format}{A character string specifying a file format. For \code{get_file}: by default, this is \dQuote{original} (the original file format). If \dQuote{RData} or \dQuote{prep} is used, an alternative is returned. If \dQuote{bundle}, a compressed directory containing a bundle of file formats is returned. For \code{get_file_metadata}, this is \dQuote{ddi}.}

\item{vars}{A character vector specifying one or more variable names, used to extract a subset of the data.}

\item{key}{A character string specifying a Dataverse server API key. If one is not specified, functions calling authenticated API endpoints will fail. Keys can be specified atomically or globally using \code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server. There are multiple Dataverse installations, but the defaults is to use the Harvard Dataverse. This can be modified atomically or globally using \code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.example.com")}.}

\item{...}{Additional arguments passed to an HTTP request function, such as \code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or \code{\link[httr]{DELETE}}.}
}
\value{
\code{get_file_metadata} returns a character vector containing a DDI metadata file. \code{get_file} returns a raw vector (or list of raw vectors, if \code{length(file) > 1}).
}
\description{
Download Dataverse File(s)
}
\details{
This function provides access to data files from a Dataverse entry.
}
\examples{
\dontrun{
# download file from: 
# https://dataverse.harvard.edu/dataset.xhtml?persistentId=doi:10.7910/DVN/ARKOTI
monogan <- get_dataverse("monogan")
monogan_data <- dataverse_contents(monogan)
d1 <- get_dataset("doi:10.7910/DVN/ARKOTI")
f <- get_file(d1$files$datafile$id[3])

# check file metadata
m1 <- get_file_metadata("constructionData.tab", "doi:10.7910/DVN/ARKOTI")
m2 <- get_file_metadata(2437257)

# retrieve file based on DOI and filename
f2 <- get_file("constructionData.tab", "doi:10.7910/DVN/ARKOTI")
f2 <- get_file(2692202)

# retrieve file based on "dataverse_file" object
flist <- dataset_files(2692151)
get_file(flist[[2]])

# read file as data.frame
if (require("rio")) {
  tmp <- tempfile(fileext = ".dta")
  writeBin(f, tmp)
  str(dat <- rio::import(tmp, haven = FALSE))

  # check UNF match
  #if (require("UNF")) {
  #  unf(dat) \%unf\% d1$files$datafile$UNF[3]
  #}
}
}
}
