% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWORD_dataset.R
\name{initiate_sword_dataset}
\alias{initiate_sword_dataset}
\title{Initiate dataset (SWORD)}
\usage{
initiate_sword_dataset(
  dataverse,
  body,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)
}
\arguments{
\item{dataverse}{A Dataverse alias or ID number, or an object of class \dQuote{dataverse}, perhaps as returned by \code{\link{service_document}}.}

\item{body}{A list containing one or more metadata fields. Field names must be valid Dublin Core Terms labels (see details, below). The \samp{title}, \samp{description}, and \samp{creator} fields are required.}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server.
Multiple Dataverse installations exist, with \code{"dataverse.harvard.edu"} being the
most major. The server can be defined each time within a function, or it can
be set as a default via an environment variable. To set a default, run
\code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.harvard.edu")}
or add \verb{DATAVERSE_SERVER = "dataverse.harvard.edu} in one's \code{.Renviron}
file (\code{usethis::edit_r_environ()}), with the appropriate domain as its value.}

\item{...}{Additional arguments passed to an HTTP request function, such as
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}.}
}
\value{
An object of class \dQuote{dataset_atom}.
}
\description{
Initiate a SWORD (possibly unpublished) dataset
}
\details{
This function is used to initiate a dataset in a (SWORD) Dataverse by supplying relevant metadata. The function is part of the SWORD API (see \href{https://www.ietf.org/rfc/rfc5023.txt}{Atom entry specification}), which is used to upload data to a Dataverse server.
Allowed fields are:
\dQuote{abstract}, \dQuote{accessRights}, \dQuote{accrualMethod},
\dQuote{accrualPeriodicity}, \dQuote{accrualPolicy}, \dQuote{alternative},
\dQuote{audience}, \dQuote{available}, \dQuote{bibliographicCitation},
\dQuote{conformsTo}, \dQuote{contributor}, \dQuote{coverage}, \dQuote{created},
\dQuote{creator}, \dQuote{date}, \dQuote{dateAccepted}, \dQuote{dateCopyrighted},
\dQuote{dateSubmitted}, \dQuote{description}, \dQuote{educationLevel}, \dQuote{extent},
\dQuote{format}, \dQuote{hasFormat}, \dQuote{hasPart}, \dQuote{hasVersion},
\dQuote{identifier}, \dQuote{instructionalMethod}, \dQuote{isFormatOf},
\dQuote{isPartOf}, \dQuote{isReferencedBy}, \dQuote{isReplacedBy}, \dQuote{isRequiredBy},
\dQuote{issued}, \dQuote{isVersionOf}, \dQuote{language}, \dQuote{license},
\dQuote{mediator}, \dQuote{medium}, \dQuote{modified}, \dQuote{provenance},
\dQuote{publisher}, \dQuote{references}, \dQuote{relation}, \dQuote{replaces},
\dQuote{requires}, \dQuote{rights}, \dQuote{rightsHolder}, \dQuote{source},
\dQuote{spatial}, \dQuote{subject}, \dQuote{tableOfContents}, \dQuote{temporal},
\dQuote{title}, \dQuote{type}, and \dQuote{valid}.
}
\note{
There are two ways to create dataset: native API (\code{\link{create_dataset}}) and SWORD API (\code{initiate_sword_dataset}).
}
\examples{
\dontrun{
# retrieve your service document (dataverse list)
d <- service_document()

# create a list of metadata
metadat <- list(title = "My Study",
                creator = "Doe, John",
                description = "An example study")

# create the dataset in first dataverse
dat <- initiate_sword_dataset(d[[2]], body = metadat)

# add files to dataset
tmp <- tempfile(fileext = ".csv")
write.csv(iris, file = tmp)
add_file(dat, file = tmp)

# publish dataset
publish_dataset(dat)
}
}
\references{
\href{http://dublincore.org/documents/dcmi-terms/}{Dublin Core Metadata Terms}
}
\seealso{
Managing a Dataverse: \code{\link{publish_dataverse}}; Managing a dataset: \code{\link{dataset_atom}}, \code{\link{list_datasets}}, \code{\link{create_dataset}}, \code{\link{delete_sword_dataset}}, \code{\link{publish_dataset}}; Managing files within a dataset: \code{\link{add_file}}, \code{\link{delete_file}}
}
