% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transpose.R
\name{data_transpose}
\alias{data_transpose}
\title{Transpose a dataframe}
\usage{
data_transpose(data, verbose = TRUE, ...)
}
\arguments{
\item{data}{A data frame, or an object that can be coerced to a data frame.}

\item{verbose}{Silence warnings and/or messages by setting it to \code{FALSE}.}

\item{...}{Other arguments passed to or from other functions.}
}
\description{
Transpose a dataframe. It's the equivalent of using \code{t()} but restores the data.frame class, and prints a warning if the data type is modified (see example).
}
\examples{
transposed <- data_transpose(iris)
transposed[1:5]

transposed <- data_transpose(iris[1:4]) # Only numeric = no warning
}
