% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groves.R
\name{pick_grove}
\alias{pick_grove}
\title{Pick a grove in the case of multiple groves in a set of trees.}
\usage{
pick_grove(grove_list, criterion = "taxa", datelife_result)
}
\arguments{
\item{grove_list}{A list of vectors of tree indices. Each element is a grove.}

\item{criterion}{Defaults to \code{criterion = "taxa"}. Used for chronogram summarizing, i.e., obtaining a single
summary chronogram from a group of input chronograms.
For summarizing approaches that return a single summary tree from a group of
phylogenetic trees, it is necessary that the latter form a grove, roughly,
a sufficiently overlapping set of taxa between trees, see Ané et al. (2009) \doi{10.1007/s00026-009-0017-x}.
In rare cases, a group of trees can have multiple groves. This argument indicates
whether to get the grove with the most trees (\code{criterion = "trees"}) or the
most taxa (\code{criterion = "taxa"}).}

\item{datelife_result}{A \code{datelifeResult} object. Only needed for \code{criterion = "taxa"}.}
}
\value{
A numeric vector of the elements of the picked grove.
}
\description{
Pick a grove in the case of multiple groves in a set of trees.
}
