% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_median.R
\name{datelife_result_median}
\alias{datelife_result_median}
\title{Get a median summary chronogram from a \code{datelifeResult} object.}
\usage{
datelife_result_median(datelife_result, ...)
}
\arguments{
\item{datelife_result}{A \code{datelifeResult} object, usually an output of \code{\link[=get_datelife_result]{get_datelife_result()}}.}

\item{...}{
  Arguments passed on to \code{\link[=summary_matrix_to_phylo]{summary_matrix_to_phylo}}
  \describe{
    \item{\code{summ_matrix}}{Any summary patristic distance matrix, such as the ones obtained with \code{\link[=datelife_result_sdm_matrix]{datelife_result_sdm_matrix()}} or \code{\link[=datelife_result_median_matrix]{datelife_result_median_matrix()}}.}
    \item{\code{total_distance}}{Whether the input \code{summ_matrix} stores total age distance
(from tip to tip) or distance from node to tip. Default to \code{TRUE},
divides the matrix in half, if \code{FALSE} it will take it as is.}
    \item{\code{use}}{A character vector indicating what type of age to use for summary tree.
One of the following:
\describe{
\item{"mean"}{It will use the \code{\link[=mean]{mean()}} of the node ages in \code{summ_matrix}.}
\item{"median"}{It uses the \code{\link[stats:median]{stats::median()}} age of node ages in \code{summ_matrix}.}
\item{"min"}{It will use the \code{\link[=min]{min()}} age from node ages in \code{summ_matrix}.}
\item{"max"}{Choose this if you wanna be conservative; it will use the \code{\link[=max]{max()}}
age from node ages in \code{summ_matrix}.}
\item{"midpoint"}{It will use the mean of minimum age and maximum age.}
}}
    \item{\code{target_tree}}{A \code{phylo} object. Use this in case you want a specific
backbone for the output tree.}
    \item{\code{datelife_query}}{A \code{datelifeQuery} object, usually an output of \code{\link[=make_datelife_query]{make_datelife_query()}}.}
  }}
}
\value{
A \code{phylo} object.
}
\description{
Get a median summary chronogram from a \code{datelifeResult} object.
}
