% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{felid_sdm}
\alias{felid_sdm}
\title{SDM tree of a datelifeResult object of all Felidae species.}
\format{
A list of two elements, containing the summary of a datelifeResult object
\describe{
\item{phy}{An ultrametric phylo object with the SDM tree.}
\item{data}{A datelifeResult object with data used to construct phy}
}
}
\source{
\url{http://opentreeoflife.org}
}
\usage{
felid_sdm
}
\description{
SDM tree of a datelifeResult object of all Felidae species.
}
\details{
Generated with:
felid_spp <- make_datelife_query(input = "felidae", get_spp_from_taxon = TRUE)
felid_gdr <- get_datelife_result(input = felid_spp, get_spp_from_taxon = TRUE)
felid_sdm <- datelife_result_sdm_phylo(felid_gdr)
usethis::use_data(felid_sdm)
}
\keyword{chronogram}
\keyword{felidae}
\keyword{otol}
\keyword{sdm}
\keyword{subset}
\keyword{supertree}
\keyword{tree}
