% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_internal.R
\name{patristic_matrix_array_phylo_congruify}
\alias{patristic_matrix_array_phylo_congruify}
\title{Congruify a patristic matrix array from a given \code{phylo} object.}
\usage{
patristic_matrix_array_phylo_congruify(
  patristic_matrix,
  target_tree,
  dating_method = "PATHd8",
  attempt_fix = TRUE
)
}
\arguments{
\item{patristic_matrix}{A patristic matrix, \code{rownames} and \code{colnames} must be taxa.}

\item{target_tree}{A \code{phylo} object. Use this in case you want a specific
backbone for the output tree.}

\item{dating_method}{The method used for tree dating.}

\item{attempt_fix}{Default to \code{TRUE}. If congruification results in NA branch
lengths, it will attempt to fix them.}
}
\value{
A matrix.
}
\description{
Congruify a patristic matrix array from a given \code{phylo} object.
}
