\name{vrveg}
\alias{vrveg}
\docType{data}
\title{
Vraconnaz time series data, vegetation
}
\description{
A vegetation time series from 11 plots in the Vraconnaz peat bog, describing
species invasion and propagation after a bog burst in 1986. The corresponding
site object is \code{\link{vrsit}}
}
\usage{data("vrveg")}
\format{
  A data frame with 231 observations on the following 154 variables (the species):
  \describe{
    \item{\code{Agrostis_canina}}{a numeric vector}
    \item{\code{Agrostis_capillaris}}{a numeric vector}
    \item{\code{Agrostis_capillaris.1}}{a numeric vector}
    \item{\code{Agrostis_gigantea}}{a numeric vector}
    \item{\code{Agrostis_stolonifera}}{a numeric vector}
    \item{\code{Ajuga_reptans}}{a numeric vector}
    \item{\code{Amblystegium_riparium}}{a numeric vector}
    \item{\code{Angelica_sylvestris}}{a numeric vector}
    \item{\code{Anthoxanthum_odoratum}}{a numeric vector}
    \item{\code{Atrichum_undulatum}}{a numeric vector}
    \item{\code{Aulacomnium_palustre}}{a numeric vector}
    \item{\code{Betula_pubescens}}{a numeric vector}
    \item{\code{Brachythecium_mildeanum}}{a numeric vector}
    \item{\code{Brachythecium_mildeanum.1}}{a numeric vector}
    \item{\code{Brachythecium_rivulare}}{a numeric vector}
    \item{\code{Brachythecium_rutabulum}}{a numeric vector}
    \item{\code{Briza_media}}{a numeric vector}
    \item{\code{Bryum_pseudotriquetrum}}{a numeric vector}
    \item{\code{Calliergonella_cuspidata}}{a numeric vector}
    \item{\code{Caltha_palustris}}{a numeric vector}
    \item{\code{Campanula_rotundifolia}}{a numeric vector}
    \item{\code{Campylium_stellatum}}{a numeric vector}
    \item{\code{Cardamine_pratensis}}{a numeric vector}
    \item{\code{Carex_canescens}}{a numeric vector}
    \item{\code{Carex_davalliana}}{a numeric vector}
    \item{\code{Carex_echinata}}{a numeric vector}
    \item{\code{Carex_flava}}{a numeric vector}
    \item{\code{Carex_hostiana}}{a numeric vector}
    \item{\code{Carex_leporina}}{a numeric vector}
    \item{\code{Carex_nigra}}{a numeric vector}
    \item{\code{Carex_panicea}}{a numeric vector}
    \item{\code{Carex_pauciflora}}{a numeric vector}
    \item{\code{Carex_pulicaris}}{a numeric vector}
    \item{\code{Carex_rostrata}}{a numeric vector}
    \item{\code{Cerastium_caespitosum}}{a numeric vector}
    \item{\code{Cerastium_fontanum}}{a numeric vector}
    \item{\code{Cerastium_glomeratum}}{a numeric vector}
    \item{\code{Ceratodon_purpureus}}{a numeric vector}
    \item{\code{Cirriphyllum_piliferum}}{a numeric vector}
    \item{\code{Cirsium_palustre}}{a numeric vector}
    \item{\code{Climacium_dendroides}}{a numeric vector}
    \item{\code{Cratoneuron_filicinum}}{a numeric vector}
    \item{\code{Crepis_mollis}}{a numeric vector}
    \item{\code{Crepis_paludosa}}{a numeric vector}
    \item{\code{Crepis_paludosa.1}}{a numeric vector}
    \item{\code{Crocus_albiflorus}}{a numeric vector}
    \item{\code{Ctenidium_molluscum}}{a numeric vector}
    \item{\code{Dactylorhiza_fistulosa}}{a numeric vector}
    \item{\code{Dactylorhiza_maculata}}{a numeric vector}
    \item{\code{Danthonia_decumbens}}{a numeric vector}
    \item{\code{Deschampsia_cespitosa}}{a numeric vector}
    \item{\code{Drepanocladus_revolvens_aggr.}}{a numeric vector}
    \item{\code{Drepanocladus_vernicosus.1}}{a numeric vector}
    \item{\code{Eleocharis_quinqueflora}}{a numeric vector}
    \item{\code{Epilobium_angustifolium}}{a numeric vector}
    \item{\code{Epilobium_montanum}}{a numeric vector}
    \item{\code{Epilobium_montanum.1}}{a numeric vector}
    \item{\code{Epilobium_palustre}}{a numeric vector}
    \item{\code{Epipactis_palustris}}{a numeric vector}
    \item{\code{Equisetum_fluviatile}}{a numeric vector}
    \item{\code{Equisetum_palustre}}{a numeric vector}
    \item{\code{Eriophorum_angustifolium}}{a numeric vector}
    \item{\code{Eriophorum_latifolium}}{a numeric vector}
    \item{\code{Eurhynchium_speciosum}}{a numeric vector}
    \item{\code{Festuca_arundinacea}}{a numeric vector}
    \item{\code{Festuca_pratensis}}{a numeric vector}
    \item{\code{Festuca_rubra_aggr.}}{a numeric vector}
    \item{\code{Filipendula_ulmaria}}{a numeric vector}
    \item{\code{Fissidens_adianthoides}}{a numeric vector}
    \item{\code{Fragaria_vesca}}{a numeric vector}
    \item{\code{Galeopsis_tetrahit}}{a numeric vector}
    \item{\code{Galium_palustre}}{a numeric vector}
    \item{\code{Galium_uliginosum}}{a numeric vector}
    \item{\code{Geum_rivale}}{a numeric vector}
    \item{\code{Homalothecium_nitens}}{a numeric vector}
    \item{\code{Hypericum_maculatum}}{a numeric vector}
    \item{\code{Juncus_acutiflorus}}{a numeric vector}
    \item{\code{Juncus_alpinoarticulatus}}{a numeric vector}
    \item{\code{Juncus_articulatus}}{a numeric vector}
    \item{\code{Juncus_effusus}}{a numeric vector}
    \item{\code{Lathyrus_pratensis}}{a numeric vector}
    \item{\code{Leontodon_hispidus}}{a numeric vector}
    \item{\code{Lophocolea_heterophylla}}{a numeric vector}
    \item{\code{Lotus_corniculatus}}{a numeric vector}
    \item{\code{Luzula_campestris}}{a numeric vector}
    \item{\code{Luzula_multiflora}}{a numeric vector}
    \item{\code{Melampyrum_pratense}}{a numeric vector}
    \item{\code{Mnium_hornum}}{a numeric vector}
    \item{\code{Molinia_caerulea}}{a numeric vector}
    \item{\code{Myosotis_cespitosa}}{a numeric vector}
    \item{\code{Myosotis_nemorosa}}{a numeric vector}
    \item{\code{Myosotis_scorpioides}}{a numeric vector}
    \item{\code{Myosoton_aquaticum}}{a numeric vector}
    \item{\code{Parnassia_palustris}}{a numeric vector}
    \item{\code{Pedicularis_palustris}}{a numeric vector}
    \item{\code{Pellia_neesiana}}{a numeric vector}
    \item{\code{Petasites_albus}}{a numeric vector}
    \item{\code{Phragmites_communis}}{a numeric vector}
    \item{\code{Picea_abies}}{a numeric vector}
    \item{\code{Picea_excelsa}}{a numeric vector}
    \item{\code{Pinguicula_vulgaris}}{a numeric vector}
    \item{\code{Plagiomnium_affine_aggr.}}{a numeric vector}
    \item{\code{Pleurozium_schreberi}}{a numeric vector}
    \item{\code{Poa_pratensis}}{a numeric vector}
    \item{\code{Poa_trivialis}}{a numeric vector}
    \item{\code{Polygala_amarella}}{a numeric vector}
    \item{\code{Polygonum_bistorta}}{a numeric vector}
    \item{\code{Polytrichum_commune}}{a numeric vector}
    \item{\code{Polytrichum_formosum}}{a numeric vector}
    \item{\code{Polytrichum_strictum}}{a numeric vector}
    \item{\code{Populus_tremula}}{a numeric vector}
    \item{\code{Potentilla_erecta}}{a numeric vector}
    \item{\code{Potentilla_palustris}}{a numeric vector}
    \item{\code{Prunella_vulgaris}}{a numeric vector}
    \item{\code{Ranunculus_acris}}{a numeric vector}
    \item{\code{Ranunculus_auricomus}}{a numeric vector}
    \item{\code{Rhinanthus_alectorolophus}}{a numeric vector}
    \item{\code{Rhinanthus_minor}}{a numeric vector}
    \item{\code{Rhytidiadelphus_squarrosus}}{a numeric vector}
    \item{\code{Rhytidiadelphus_triquetrus}}{a numeric vector}
    \item{\code{Riccardia_multifida}}{a numeric vector}
    \item{\code{Rumex_acetosa}}{a numeric vector}
    \item{\code{Salix_caprea}}{a numeric vector}
    \item{\code{Salix_cinerea}}{a numeric vector}
    \item{\code{Salix_cinerea_cf.}}{a numeric vector}
    \item{\code{Salix_cinerea_.S}}{a numeric vector}
    \item{\code{Salix_myrsinifolia}}{a numeric vector}
    \item{\code{Salix_myrsinifolia_.S}}{a numeric vector}
    \item{\code{Salix_purpurea}}{a numeric vector}
    \item{\code{Salix_repens}}{a numeric vector}
    \item{\code{Sanguisorba_officinalis}}{a numeric vector}
    \item{\code{Scleropodium_purum}}{a numeric vector}
    \item{\code{Silene_flos.cuculi}}{a numeric vector}
    \item{\code{Stellaria_graminea}}{a numeric vector}
    \item{\code{Stellaria_media}}{a numeric vector}
    \item{\code{Succisa_pratensis}}{a numeric vector}
    \item{\code{Swertia_perennis}}{a numeric vector}
    \item{\code{Tomentypnum_nitens}}{a numeric vector}
    \item{\code{Trichophorum_cespitosum}}{a numeric vector}
    \item{\code{Trollius_europaeus_.cf.}}{a numeric vector}
    \item{\code{Tussilago_farfara}}{a numeric vector}
    \item{\code{Vaccinium_myrtillus}}{a numeric vector}
    \item{\code{Vaccinium_uliginosum}}{a numeric vector}
    \item{\code{Vaccinium_vitis.idaea}}{a numeric vector}
    \item{\code{Valeriana_dioeca}}{a numeric vector}
    \item{\code{Valeriana_officinalis}}{a numeric vector}
    \item{\code{Valerianella_locusta}}{a numeric vector}
    \item{\code{Veronica_beccabunga}}{a numeric vector}
    \item{\code{Veronica_chamaedrys}}{a numeric vector}
    \item{\code{Vicia_cracca}}{a numeric vector}
    \item{\code{Viola_palustris}}{a numeric vector}
    \item{\code{litiere_seche}}{a numeric vector}
    \item{\code{tourbe_nue}}{a numeric vector}
    \item{\code{eau_libre}}{a numeric vector}
  }
}
\details{
Note that this is a data frame whereas the corresponding time (years) is listed in \code{\link{vrsit}}.
}
\source{
Feldmeyer-Christe, E., Kuechler, M. and Wildi, O. 2011. Patterns of early succession on bare peat in a
Swiss mire after a bog burst. Journal of Vegetation Science 22: 943-954.
}
\references{
Wildi, O. 2017. Data Analysis in Vegetation Ecology. 3rd ed. CABI, Oxfordshire, Boston.
}
\examples{
data(vrveg)
str(vrveg)
}
\keyword{datasets}
