% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbflob.R
\name{delete_flob}
\alias{delete_flob}
\title{Delete flob}
\usage{
delete_flob(column_name, table_name, key, conn)
}
\arguments{
\item{column_name}{A string of the name of the BLOB column.}

\item{table_name}{A string of the name of the existing table.}

\item{key}{A data.frame whose columns and values are used to filter the
table to a single row (this in combination with the \code{column_name}
argument are used to target a single cell within the table to modify).}

\item{conn}{A SQLite connection object.}
}
\value{
An invisible copy of the deleted flob.
}
\description{
Delete a flob from a SQLite database.
}
\examples{
flob <- flobr::flob(system.file("extdata", "flobr.pdf", package = "flobr"))
conn <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
DBI::dbWriteTable(conn, "Table1", data.frame(IntColumn = c(1L, 2L)))
key <- data.frame(IntColumn = 2L)
write_flob(flob, "BlobColumn", "Table1", key, conn, exists = FALSE)
DBI::dbReadTable(conn, "Table1")
delete_flob("BlobColumn", "Table1", key, conn)
DBI::dbReadTable(conn, "Table1")
DBI::dbDisconnect(conn)
}
