% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhydro_get.R
\name{get_wq}
\alias{get_wq}
\alias{getwq}
\title{Retrieve water quality data from the DBHYDRO Environmental Database}
\usage{
get_wq(station_id = NA, date_min = NA, date_max = NA, test_name = NA,
  mdl_handling = "raw", raw = FALSE, qc_strip = "N", qc_field = "N",
  test_number = NA, v_target_code = "file_csv", sample_id = NA,
  project_code = NA)
}
\arguments{
\item{station_id}{character string of station id(s). See the SFWMD station
search utility at \url{http://my.sfwmd.gov/dbhydroplsql/water_quality_data.show_group_station_characters}
for specific options}

\item{date_min}{character date must be in POSIXct YYYY-MM-DD format}

\item{date_max}{character date must be in POSIXct YYYY-MM-DD format}

\item{test_name}{character string of test name(s). See the SFWMD
Station Maps at \url{https://www.sfwmd.gov/documents-by-tag/emmaps}
for specific options}

\item{mdl_handling}{character string specifying the handling of measurement
values below the minimum detection limit (MDL). Example choices for this
argument include:
\itemize{
\item \code{raw}: Returns values exactly as they are stored in the database.
Current practice is to return values below the MDL as 0 minus the
uncertainty estimate.
\item \code{half}: Returns values below the MDL as half the MDL
\item \code{full}: Returns values below the MDL as the MDL
}}

\item{raw}{logical default is FALSE, set to TRUE to return data in "long"
format with all comments, qa information, and database codes included}

\item{qc_strip}{logical set TRUE to avoid returning QAQC flagged data entries}

\item{qc_field}{logical set TRUE to avoid returning field QC results}

\item{test_number}{numeric test name alternative (not implemented)}

\item{v_target_code}{string print to file? (not implemented)}

\item{sample_id}{numeric (not implemented)}

\item{project_code}{numeric (not implemented)}
}
\description{
Retrieve water quality data from the
DBHYDRO Environmental Database
}
\details{
By default, \code{get_wq} returns a cleaned output. First, the
cleaning function \code{\link{clean_wq}} converts the raw output from native
DBHYDRO long format (each piece of data on its own row) to wide format (each
site x variable combination in its own column). Next, the extra columns
associated with QA flags, LIMS, and District receiving are removed. Finally,
row entries associated with QA field blanks, which are used to check on
potential sources of contamination, are removed. Setting the raw flag to TRUE
will force getwq to retain information on QA field blanks as well as the
other QA fields.
}
\examples{

#one variable and one station
get_wq(station_id = "FLAB08",
date_min = "2011-03-01", date_max = "2012-05-01",
test_name = "CHLOROPHYLLA-SALINE")

\dontrun{
#one variable at multiple stations
get_wq(station_id = c("FLAB08", "FLAB09"),
date_min = "2011-03-01", date_max = "2012-05-01",
test_name = "CHLOROPHYLLA-SALINE")

#One variable at a wildcard station
get_wq(station_id = c("FLAB0\%"),
date_min = "2011-03-01",
date_max = "2012-05-01",
test_name = "CHLOROPHYLLA-SALINE")

#multiple variables at multiple stations
get_wq(station_id = c("FLAB08", "FLAB09"),
date_min = "2011-03-01", date_max = "2012-05-01",
test_name = c("CHLOROPHYLLA-SALINE", "SALINITY"))
}
}
