% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{sql_options}
\alias{sql_options}
\title{Options for generating SQL}
\usage{
sql_options(cte = FALSE, use_star = TRUE, qualify_all_columns = FALSE)
}
\arguments{
\item{cte}{If \code{FALSE}, the default, subqueries are used. If \code{TRUE} common
table expressions are used.}

\item{use_star}{If \code{TRUE}, the default, \code{*} is used to select all columns of
a table. If \code{FALSE} all columns are explicitly selected.}

\item{qualify_all_columns}{If \code{FALSE}, the default, columns are only
qualified with the table they come from if the same column name appears in
multiple tables.}
}
\value{
A <dbplyr_sql_options> object.
}
\description{
Options for generating SQL
}
\examples{
library(dplyr, warn.conflicts = FALSE)
lf1 <- lazy_frame(key = 1, a = 1, b = 2)
lf2 <- lazy_frame(key = 1, a = 1, c = 3)

result <- left_join(lf1, lf2, by = "key") \%>\%
  filter(c >= 3)

show_query(result)
sql_options <- sql_options(cte = TRUE, qualify_all_columns = TRUE)
show_query(result, sql_options = sql_options)
}
