% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbx.R
\name{dbxUpsert}
\alias{dbxUpsert}
\title{Upsert records}
\usage{
dbxUpsert(conn, table, records, where_cols, batch_size = NULL)
}
\arguments{
\item{conn}{A DBIConnection object}

\item{table}{The table name to upsert}

\item{records}{A data frame of records to upsert}

\item{where_cols}{The columns to use for WHERE clause}

\item{batch_size}{The number of records to upsert in a single statement (defaults to all)}
}
\description{
Upsert records
}
\examples{
\dontrun{

db <- dbxConnect(adapter="postgres", dbname="dbx")
table <- "forecasts"
DBI::dbCreateTable(db, table, data.frame(id=1:3, temperature=20:22))

records <- data.frame(id=c(3, 4), temperature=c(20, 25))
upserts <- dbxUpsert(db, table, records, where_cols=c("id"))
}
}
