% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert.R
\name{dbxInsert}
\alias{dbxInsert}
\title{Insert records}
\usage{
dbxInsert(conn, table, records, batch_size = NULL, returning = NULL)
}
\arguments{
\item{conn}{A DBIConnection object}

\item{table}{The table name to insert}

\item{records}{A data frame of records to insert}

\item{batch_size}{The number of records to insert in a single statement (defaults to all)}

\item{returning}{Columns to return}
}
\description{
Insert records
}
\examples{
db <- dbxConnect(adapter="sqlite", dbname=":memory:")
table <- "forecasts"
DBI::dbCreateTable(db, table, data.frame(id=1:3, temperature=20:22))

records <- data.frame(temperature=c(32, 25))
dbxInsert(db, table, records)
}
