% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dcBuildInfoDataFrame}
\alias{dcBuildInfoDataFrame}
\title{Function to build an object of the S4 class InfoDataframe from an input file}
\usage{
dcBuildInfoDataFrame(input.file, output.file = "InfoDataFrame.RData")
}
\arguments{
\item{input.file}{an input file used to build the object. For example,
a file containing InterPro domains (InterPro) can be found in
\url{http://supfam.org/dcGOR/data/InterPro/InterPro.txt}. As seen in
this example, the input file must contain the header (in the first
row), and entries in the first column intend to be domain identities
(and must be unique)}

\item{output.file}{an output file used to save the built object as an
RData-formatted file. If NULL, this file will be saved into
"InfoDataFrame.RData" in the current working local directory}
}
\value{
Any use-specified variable that is given on the right side of the
assigement sign '<-', which contains the built
\code{dcBuildInfoDataFrame} object.
Also, an RData file specified in "output.file" is saved in the local
directory.
}
\description{
\code{dcBuildInfoDataFrame} is supposed to build an object of of the S4
class \code{\link{InfoDataFrame}}, given an input file. This input file
can, for example, contain the domain information.
}
\note{
If there are no use-specified variable that is given on the right side
of the assigement sign '<-', then no object will be loaded onto the
working environment.
}
\examples{
\dontrun{
# build an "InfoDataFrame" object that contains information on InterPro domains (InterPro)
InterPro <-
dcBuildInfoDataFrame(input.file="http://supfam.org/dcGOR/data/InterPro/InterPro.txt",
output.file="InterPro.RData")
InterPro
}
}
\seealso{
\code{\link{InfoDataFrame}}
}

