% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cov_eval}
\alias{cov_eval}
\title{Var-cov matrix evaluation}
\usage{
cov_eval(H_t, cov_proxy = NULL, r_t = NULL, loss = "FROB")
}
\arguments{
\item{H_t}{Estimated covariance matrix, formatted as array}

\item{cov_proxy}{\strong{optional} Covariance matrix, formatted as array}

\item{r_t}{\strong{optional} List of daily returns used to calculate H_t. If parameter 'cov_proxy' is not provided, then
r_t must be included. In this case, a (noise) proxy will be automatically used}

\item{loss}{Robust loss function to use. Valid choices are: "FROB" for Frobenius (by default), "SFROB" for Squared Frobenius,
"EUCL" for Euclidean, "QLIKE" for QLIKE and "RMSE" for Root Mean Squared Errors}
}
\value{
The value of the loss for each \eqn{t}
}
\description{
Evaluates the estimated var-cov matrix H_t with respect to a covariance proxy, under different robust loss functions
\insertCite{laurent2013loss}{dccmidas}. The losses considered are also used in \insertCite{amendola_2020;textual}{dccmidas}.
}
\examples{
\donttest{
require(xts)
# open to close daily log-returns
r_t_s<-log(sp500['2010/2019'][,3])-log(sp500['2010/2019'][,1])
r_t_n<-log(nasdaq['2010/2019'][,3])-log(nasdaq['2010/2019'][,1])
r_t_f<-log(ftse100['2010/2019'][,3])-log(ftse100['2010/2019'][,1])
db_m<-merge.xts(r_t_s,r_t_n,r_t_f)
db_m<-db_m[complete.cases(db_m),]
colnames(db_m)<-c("S&P500","NASDAQ","FTSE100")
# list of returns
r_t<-list(db_m[,1],db_m[,2],db_m[,3])
# estimation
K_c<-144
N_c<-36
cdcc_est<-dcc_fit(r_t,univ_model="sGARCH",distribution="norm",
corr_model="DCCMIDAS",N_c=N_c,K_c=K_c)
cov_eval(cdcc_est$H_t,r_t=r_t)[(K_c+1):dim(cdcc_est$H_t)[3]]
}
}
\references{
\insertAllCited{}
}
