% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dcov}
\alias{dcov}
\title{Distance Covariance}
\usage{
dcov(x,y)
}
\arguments{
\item{x}{numeric vector}

\item{y}{numeric vector}
}
\value{
Returns a numeric value: the distance covariance between x and y.
}
\description{
Distance Covariance
}
\details{
Implements the algorithm described in Chaudhuri, Hu (2019) \doi{10.1016/j.csda.2019.01.016} which only has O(n log(n)) complexity.
}
\examples{
\dontrun{

set.seed(1)
x < -rnorm(1000)
y < -x ^ 2

dcov(x, y)
dvov(x, x)
dvov(y, y)

}
}
