% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-annotation-keys.R
\name{check_annotation_keys}
\alias{check_annotation_keys}
\alias{check_annotation_keys.NULL}
\alias{check_annotation_keys.synapseclient.entity.File}
\alias{check_annotation_keys.data.frame}
\alias{check_annotation_keys.synapseclient.table.CsvFileTable}
\title{Check annotation keys}
\usage{
check_annotation_keys(x, annotations, ...)

\method{check_annotation_keys}{`NULL`}(x, annotations, ...)

\method{check_annotation_keys}{synapseclient.entity.File}(x, annotations, syn, ...)

\method{check_annotation_keys}{data.frame}(x, annotations, ...)

\method{check_annotation_keys}{synapseclient.table.CsvFileTable}(x, annotations, ...)
}
\arguments{
\item{x}{An object to check.}

\item{annotations}{A data frame of annotation definitions. Must contain at
least three columns: \code{key}, \code{value}, and \code{columnType}.}

\item{...}{Additional parameters passed to \code{\link[=check_keys]{check_keys()}}}

\item{syn}{Synapse client object}
}
\value{
A condition object indicating whether keys match the given annotation
dictionary. Erroneous keys are included as data within the object.
}
\description{
Checks that all annotation keys on a file, in a file view, or in a data frame
are valid annotations. \code{check_annotation_keys()} returns any invalid
annotation keys; \code{valid_annotation_keys()} returns \emph{valid} annotation keys.
}
\section{Methods (by class)}{
\itemize{
\item \code{NULL}: Return NULL

\item \code{synapseclient.entity.File}: Check annotation keys in a Synapse file

\item \code{data.frame}: Check annotation keys in a data frame

\item \code{synapseclient.table.CsvFileTable}: Check annotation keys for a Synapse table
}}

\examples{
annots <- data.frame(
  key = c("assay", "fileFormat", "fileFormat", "fileFormat", "species"),
  value = c("rnaSeq", "fastq", "txt", "csv", "Human"),
  columnType = c("STRING", "STRING", "STRING", "STRING", "STRING")
)
dat1 <- data.frame(x = 1)
dat2 <- data.frame(assay = "rnaSeq")
check_annotation_keys(dat1, annots)
check_annotation_keys(dat2, annots)

\dontrun{
syn <- synapse$Synapse()
syn$login()
annots <- get_synapse_annotations(syn = syn)
my_file <- syn$get("syn11931757", downloadFile = FALSE)
check_annotation_keys(my_file, annots, syn)

dat <- data.frame(non_annotation = 5, assay = "rnaSeq")
check_annotation_keys(dat, annots)

fv <- syn$tableQuery("SELECT * FROM syn17020234")
check_annotation_keys(fv, annots)

# If you don't specify an annotations data frame, these functions will
# download annotations automatically using `get_synapse_annotations()` (must
# be logged in to Synapse)
my_file <- syn$get("syn11931757", downloadFile = FALSE)
check_annotation_keys(my_file, syn = syn)
}
}
\seealso{
\code{\link[=valid_annotation_keys]{valid_annotation_keys()}}
}
