% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{check_pass}
\alias{check_pass}
\alias{check_warn}
\alias{check_fail}
\title{Create custom conditions for reporting}
\usage{
check_pass(msg, behavior, data = NULL)

check_warn(msg, behavior, data = NULL)

check_fail(msg, behavior, data = NULL)
}
\arguments{
\item{msg}{Message to report}

\item{behavior}{Statement of the correct behavior (i.e. what the higher level
function was checking for)}

\item{data}{Data to return (e.g. invalid values that need attention)}
}
\value{
An S3 object of class "check_pass", "check_warn", or "check_fail"
}
\description{
These functions create custom condition objects with subclasses "check_pass",
"check_warn", and "check_fail" (inheriting from "message", "warning", or
"error", respectively). Validation functions such as
\code{\link[dccvalidator:check_col_names]{dccvalidator::check_col_names()}} use these to report results and provide
additional data on the source of errors or invalid data if needed.
}
\examples{
check_pass(msg = "Success!", behavior = "Files should be complete")
check_warn(
  msg = "Warning, some data is missing",
  behavior = "Files should be complete",
  data = c("specimenID", "assay") # columns with missing data
)
check_fail(
  msg = "Error, some required data is missing",
  behavior = "Files should be complete",
  data = c("specimenID", "assay") # columns with missing data
)
}
