% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambdas.R
\name{lambdas}
\alias{lambdas}
\title{Lambdas}
\usage{
lambdas(deasol)
}
\arguments{
\item{deasol}{Object of class dea or dea_fuzzy obtained with some of the dea model functions.}
}
\description{
Extract the lambdas of the DMUs from a dea or dea_fuzzy solution.
}
\examples{
 data("Coll_Blasco_2006")
 data_example <- read_data(Coll_Blasco_2006,
                           dmus=1,
                           ni=2, 
                           no=2)
 result <- model_multiplier(data_example, 
                            orientation="io",
                            rts="crs")
 lambdas(result)
 
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
