% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.deafuzzy.R
\name{summary.dea_fuzzy}
\alias{summary.dea_fuzzy}
\title{Summary Fuzzy DEA models.}
\usage{
\method{summary}{dea_fuzzy}(object, ..., exportExcel = TRUE,
  filename = NULL)
}
\arguments{
\item{object}{An object of class \code{"dea_fuzzy"} obtained with a fuzzy dea 
model function (\code{modelfuzzy_guotanaka}, \code{modelfuzzy_kaoliu},
\code{modelfuzzy_possibilistic}).}

\item{...}{Extra options}

\item{exportExcel}{Logical value. If TRUE (default) the results are also exported to an Excel file}

\item{filename}{Character string. Absolute filename (including path) of the exported Excel file. 
If NULL, then the name of the file will be "ResultsDEA"+timestamp.xlsx.}
}
\value{
If the model is that from Guo and Tanaka (\code{modelfuzzy_guotanaka}), it returns a data.frame
with columns: DMU, alpha cuts and efficiencies.
For the possibilistic model (\code{modelfuzzy_possibilistic}) it returns a data.frame with columns:
DMU, alpha-cuts, efficiencies and the corresponding lambda values
For the Kao and Liu model (\code{modelfuzzy_kaoliu}), the result may depend on the crisp sub-model used. 
It will contain a data.frame with the efficiencies (if any), the slacks and superslacks (if any), 
the lambda values and the targets.

If \code{exportExcel} is TRUE, then an Excel file will be created containing as many sheets as necessary 
depending on the variables returned.
}
\description{
Summary of the results obtained by a fuzzy DEA model.
}
\examples{
data("Leon2003")
data_example <- read_data_fuzzy(Leon2003,
                                dmus = 1, 
                                inputs.mL = 2, 
                                inputs.dL = 3, 
                                outputs.mL = 4, 
                                outputs.dL = 5)
result <- modelfuzzy_possibilistic(data_example, 
                                   h = seq(0, 1, by = 0.1), 
                                   orientation = "io", 
                                   rts = "vrs")
summary(result)
}
\references{
León, T.; Liern, V. Ruiz, J.; Sirvent, I. (2003). "A Possibilistic Programming Approach to the Assessment of Efficiency with DEA Models", Fuzzy Sets and Systems, 139, 407–419. \url{https://doi.org/10.1016/S0165-0114(02)00608-5}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
