% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plainNames2data.frameNames.R
\name{plainNames2data.frameNames}
\alias{plainNames2data.frameNames}
\title{Transform model function variable names: plain to data.frame names.}
\usage{
plainNames2data.frameNames(modelFunction, plainNames)
}
\arguments{
\item{modelFunction}{a function whose body contains variables with plain names. The 
function must not contain any arguments.}

\item{plainNames}{a \code{character} vector containing the names of the  variables that
shall be transformed.}
}
\value{
The transformed function which is of the form:
 \preformatted{
   function(x){
     ...
     <expression with x$variable1>
     ...
   }
 }
}
\description{
The variable names of a function are transformed from plain variable names to data.frame names
of the form \code{x$<globalName>}.
}
\details{
The input function must be of the form:
 \preformatted{
   modelFunction<-function(){
     ...
     <expression with variable1>
     ...
   }
 }
}
\section{Warning}{

  If there are local functions within the function \code{modelFunction} defined, whose arguments
  have identical names to any of the \code{plainNames} the function fails!
}
\examples{
 profit1<-function(){
   list(Profit=revenue-costs)
 }
 profit2<-plainNames2data.frameNames(modelFunction=profit1, 
                                               plainNames=c("revenue", "costs"))
 print(profit2)
 is.function(profit2)
 profit2(data.frame("revenue"=10,"costs"=2))
}
\seealso{
\code{\link{mcSimulation}}, \code{\link{estimate}}
}

