% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramtnormci_numeric.R
\name{paramtnormci_numeric}
\alias{paramtnormci_numeric}
\title{Return parameters of truncated normal distribution based on a confidence interval.}
\usage{
paramtnormci_numeric(
  p,
  ci,
  lowerTrunc = -Inf,
  upperTrunc = Inf,
  relativeTolerance = 0.05,
  rootMethod = "probability",
  ...
)
}
\arguments{
\item{p}{\code{numeric} 2-dimensional vector; probabilities of lower and upper bound of the
corresponding confidence interval.}

\item{ci}{\code{numeric} 2-dimensional vector; lower, i.e \code{ci[[1]]}, and upper bound, i.e
\code{ci[[2]]}, of the  confidence interval.}

\item{lowerTrunc}{\code{numeric}; lower truncation point of the distribution (>= \code{-Inf}).}

\item{upperTrunc}{\code{numeric}; upper truncation point of the distribution (<= \code{Inf}).}

\item{relativeTolerance}{\code{numeric}; the relative tolerance level of deviation of the
generated confidence interval from the specified interval. If this deviation is greater than
\code{relativeTolerance} a warning is given.}

\item{rootMethod}{\code{character}; if \code{="probability"} the equation defining the parameters \code{mean} and
\code{sd} is the difference between calculated and given probabilities of the confidence
interval; if \code{="quantile"} the equation defining the parameters is the difference between
calculated and given upper and lower value of the confidence interval.}

\item{...}{Further parameters passed to \code{\link[nleqslv]{nleqslv}}.}
}
\value{
A list with elements \code{mean} and \code{sd}, i.e. the parameters of the underlying
  normal distribution.
}
\description{
This function calculates the distribution parameters, i.e. \code{mean} and \code{sd}, of a
truncated normal distribution from an arbitrary confidence interval.
}
\details{
For details of the truncated normal distribution see \code{\link[msm]{tnorm}}.
#' @importFrom nleqslv nleqslv
}
\seealso{
\code{\link[msm]{tnorm}}, \code{\link[nleqslv]{nleqslv}}
}
