% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_layer}
\alias{add_layer}
\title{Add any kind of layer to the deckgl widget}
\usage{
add_layer(deckgl, class_name, id, data = NULL, properties = list(),
  ..., tooltip = NULL, source = NULL)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{class_name}{The name of the JavaScript layer class, e. g. \code{ScatterplotLayer}.}

\item{id}{The unique id of the layer.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class.}

\item{...}{More properties that will be added to the \code{properties} object. This can be useful
if you want to use a properties object for more than one layer.}

\item{tooltip}{A tooltip template that defines what should be displayed when the mouse enters an object.
You can also pass a list with the properties \code{html} and \code{style}. See also \code{\link{use_tooltip}}.}

\item{source}{The ID of the data source ...}
}
\value{
A deckgl widget object.
}
\description{
Generic function to add any kind of layer to the deckgl widget.
Usually you will not use this one but any of the \code{add_*_layer} functions instead.
}
