% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kww.R
\name{kww}
\alias{kww}
\title{Koopman-Wang-Wei Decomposition of Gross Exports}
\usage{
kww(x)
}
\arguments{
\item{x}{an object of the class 'decompr' obtained from \code{\link{load_tables_vectors}}.}
}
\value{
A data frame where a countries gross exports is decomposed into 9 components (columns), as detailed in Figure 1 of the AER paper:
 \tabular{llll}{
 \emph{Term} \tab\tab\tab \emph{Description} \cr\cr\cr
 DVA_FIN \tab\tab\tab Domestic VA in final goods exports. \cr\cr\cr
 DVA_INT \tab\tab\tab Domestic VA in intermediate exports absorbed by direct importers (used to produce a locally consumed final good). \cr\cr\cr
 DVA_INTrex \tab\tab\tab Domestic VA in intermediate exports reexported to third countries and absorbed there. \cr\cr\cr
 RDV_FIN \tab\tab\tab Domestic VA in intermediate exports that returns home via final imports. \cr\cr\cr
 RDV_INT \tab\tab\tab Domestic VA in intermediate exports that returns home via intermediate imports (used to produce a domestically consumed final good). \cr\cr\cr
 DDC \tab\tab\tab Double counted DVA in intermediate exports (arising from 2-way trade in intermediate goods). \cr\cr\cr % (VA already captured in RDV_FIN and RDV_INT). -> Not strictly correct.
 FVA_FIN \tab\tab\tab Foreign VA in final goods exports.  \cr\cr\cr
 FVA_INT \tab\tab\tab Foreign VA in intermediate exports. \cr\cr\cr
 FDC \tab\tab\tab Double counted FVA in intermediate exports (arising from 2-way trade in intermediate goods). \cr % (VA already captured in FVA_INT). -> Not strictly correct.
 }
}
\description{
This function performs the Koopman-Wang-Wei (2014) decomposition of a countries gross exports into 9 separate value added components.
}
\examples{
# Load example data
data(leather)

# Create intermediate object (class 'decompr')
decompr_object <- load_tables_vectors(leather)
 
# Perform the KWW decomposition
kww(decompr_object)

}
\references{
Koopman, R., Wang, Z., & Wei, S. J. (2014). Tracing value-added and double counting in gross exports. \emph{American Economic Review, 104}(2), 459-94.
}
\seealso{
\code{\link{wwz}}, \code{\link{wwz2kww}}, \code{\link{decompr-package}}
}
\author{
Sebastian Krantz
}
