% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{network}
\alias{network}
\title{network function}
\usage{
network(dims, activ = logistic(), regulariser = NULL)
}
\arguments{
\item{dims}{a vector giving the dimensions of the network. The first and last elements are respectively the input and output lengths and the intermediate elements are the dimensions of the hidden layers}

\item{activ}{either a single function or a list of activation functions, one each for the hidden layers and one for the output layer. See for example ?ReLU, ?softmax etc.}

\item{regulariser}{optional regularisation strategy, see for example ?no_regularisation (the default) ?L1_regularisation, ?L2_regularisation}
}
\value{
a list object with all information to train the network
}
\description{
A function to set up a neural network structure.
}
\examples{

net <- network( dims = c(5,10,2),
                activ=list(ReLU(),softmax()))

net <- network( dims = c(100,50,50,20),
                activ=list(ReLU(),ReLU(),softmax()),
                regulariser=L1_regularisation())

}
\references{
\enumerate{
    \item Ian Goodfellow, Yoshua Bengio, Aaron Courville, Francis Bach. Deep Learning. (2016)
    \item Terrence J. Sejnowski. The Deep Learning Revolution (The MIT Press). (2018)
    \item Neural Networks YouTube playlist by 3brown1blue: \url{https://www.youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi}
    \item{http://neuralnetworksanddeeplearning.com/}
}
}
\seealso{
\link{network}, \link{train}, \link{backprop_evaluate}, \link{MLP_net}, \link{backpropagation_MLP},
\link{logistic}, \link{ReLU}, \link{smoothReLU}, \link{ident}, \link{softmax}, \link{Qloss}, \link{multinomial},
\link{NNgrad_test}, \link{weights2list}, \link{bias2list}, \link{biasInit}, \link{memInit}, \link{gradInit},
\link{addGrad}, \link{nnetpar}, \link{nbiaspar}, \link{addList}, \link{no_regularisation}, \link{L1_regularisation},
\link{L2_regularisation}
}
