/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Peak;
import ch.fgcz.proteomics.fbdm.PeakList;
import ch.fgcz.proteomics.fbdm.ScoringConfiguration;
import ch.fgcz.proteomics.utilities.MathUtils;
import java.util.List;

public class Score {
    private double peptidMassValue;
    private double chargeValue;
    private ScoringConfiguration config;

    public Score(double peptidMass, int charge, ScoringConfiguration config) {
        this.peptidMassValue = peptidMass;
        this.chargeValue = charge;
        this.config = config;
    }

    public static double diff1(double x, double y) {
        return x - y;
    }

    public static double diff2(double x, double y, double H_MASS) {
        return x - (y + H_MASS) / 2.0;
    }

    public static double diff3(double x, double y, double H_MASS) {
        return x - (y + 2.0 * H_MASS) / 3.0;
    }

    public static double diff4(double x, double y, double H_MASS) {
        return x - (y * 2.0 + H_MASS) / 3.0;
    }

    public static double sum1(double x, double y) {
        return x + y;
    }

    public static double sum2(double x, double y, double H_MASS) {
        return x + (y + H_MASS) / 2.0;
    }

    public static double sum3(double x, double y, double H_MASS) {
        return x + (y + 2.0 * H_MASS) / 3.0;
    }

    public static double sum4(double x, double y, double H_MASS) {
        return x + (y * 2.0 + H_MASS) / 3.0;
    }

    public static int firstAminoAcidDistanceScore(double x, double y, ScoringConfiguration config) {
        int F1 = 0;
        double error = config.getErrorTolerance();
        double H_MASS = config.getH_MASS(1);
        Range aminoAcidMassRange = new Range(config.getMin() - 2.0, config.getMax() + 2.0);
        double d1xy = Math.abs(Score.diff1(x, y));
        double d2xy = Math.abs(Score.diff2(x, y, H_MASS));
        double d2yx = Math.abs(Score.diff2(y, x, H_MASS));
        double d3xy = Math.abs(Score.diff3(x, y, H_MASS));
        double d3yx = Math.abs(Score.diff3(y, x, H_MASS));
        double d4xy = Math.abs(Score.diff4(x, y, H_MASS));
        double d4yx = Math.abs(Score.diff4(y, x, H_MASS));
        if (aminoAcidMassRange.in(d1xy) || aminoAcidMassRange.in(d2xy) || aminoAcidMassRange.in(d2yx) || aminoAcidMassRange.in(d3xy) || aminoAcidMassRange.in(d3yx) || aminoAcidMassRange.in(d4xy) || aminoAcidMassRange.in(d4yx)) {
            for (int i = 0; i < config.getAaMass().size(); ++i) {
                double aa = config.getAaMass().get(i);
                double aa2 = config.getAaMassDividedTwo().get(i);
                double aa3 = config.getAaMassDividedThree().get(i);
                if (!MathUtils.fuzzyEqual(d1xy, aa, error) && !MathUtils.fuzzyEqual(d1xy, aa2, error) && !MathUtils.fuzzyEqual(d1xy, aa3, error) && !MathUtils.fuzzyEqual(d2xy, aa2, error) && !MathUtils.fuzzyEqual(d2yx, aa2, error) && !MathUtils.fuzzyEqual(d3xy, aa3, error) && !MathUtils.fuzzyEqual(d3yx, aa3, error) && !MathUtils.fuzzyEqual(d4xy, aa3, error) && !MathUtils.fuzzyEqual(d4yx, aa3, error)) continue;
                ++F1;
            }
        }
        return F1;
    }

    public static int secondComplementaryMassScore(double x, double y, double pepidMass, double charge, List<Peak> isotopicCluster, ScoringConfiguration config) {
        int F2 = 0;
        int i = 0;
        for (Peak c : isotopicCluster) {
            if (c.getMz() == x) break;
            ++i;
        }
        double H_MASS = config.getH_MASS(1);
        double s1xy = Score.sum1(x, y);
        double s2xy = Score.sum2(x, y, H_MASS);
        double s2yx = Score.sum2(y, x, H_MASS);
        double s3xy = Score.sum3(x, y, H_MASS);
        double s3yx = Score.sum3(y, x, H_MASS);
        double s4xy = Score.sum4(x, y, H_MASS);
        double s4yx = Score.sum4(y, x, H_MASS);
        double m2i = pepidMass * charge - charge * config.getH_MASS(1) + 2.0 * config.getIsotopicPeakDistance() * (double)i;
        if (MathUtils.fuzzyEqual(s1xy, m2i + config.getH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(s1xy, m2i / 2.0 + config.getH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(s1xy, m2i / 3.0 + config.getH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(s2xy, m2i / 2.0 + config.getH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(s2yx, m2i / 2.0 + config.getH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(s3xy, m2i / 3.0 + config.getH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(s3yx, m2i / 3.0 + config.getH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(s4xy, m2i / 3.0 + config.getH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(s4yx, m2i / 3.0 + config.getH_MASS(2), config.getErrorTolerance())) {
            ++F2;
        }
        return F2;
    }

    public static int thirdSideChainLossScore(double x, double y, ScoringConfiguration config) {
        int F3 = 0;
        double d1xy = Math.abs(Score.diff1(x, y));
        double d2xy = Math.abs(Score.diff2(x, y, config.getH_MASS(1)));
        double d2yx = Math.abs(Score.diff2(y, x, config.getH_MASS(1)));
        double d3xy = Math.abs(Score.diff3(x, y, config.getH_MASS(1)));
        double d3yx = Math.abs(Score.diff3(y, x, config.getH_MASS(1)));
        double d4xy = Math.abs(Score.diff4(x, y, config.getH_MASS(1)));
        double d4yx = Math.abs(Score.diff4(y, x, config.getH_MASS(1)));
        if (MathUtils.fuzzyEqual(d1xy, config.getH2O_MASS(1), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getNH3_MASS(1), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getH2O_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getNH3_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getH2O_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getNH3_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d2xy, config.getH2O_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d2xy, config.getNH3_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d2yx, config.getH2O_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d2yx, config.getNH3_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d3xy, config.getH2O_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d3xy, config.getNH3_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d3yx, config.getH2O_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d3yx, config.getNH3_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d4xy, config.getH2O_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d4xy, config.getNH3_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d4yx, config.getH2O_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d4yx, config.getNH3_MASS(3), config.getErrorTolerance())) {
            ++F3;
        }
        return F3;
    }

    public static int fourthSupportiveAZIonsScore(double x, double y, ScoringConfiguration config) {
        int F4 = 0;
        double d1xy = Math.abs(Score.diff1(x, y));
        double d2xy = Math.abs(Score.diff2(x, y, config.getH_MASS(1)));
        double d2yx = Math.abs(Score.diff2(y, x, config.getH_MASS(1)));
        double d3xy = Math.abs(Score.diff3(x, y, config.getH_MASS(1)));
        double d3yx = Math.abs(Score.diff3(y, x, config.getH_MASS(1)));
        double d4xy = Math.abs(Score.diff4(x, y, config.getH_MASS(1)));
        double d4yx = Math.abs(Score.diff4(y, x, config.getH_MASS(1)));
        if (MathUtils.fuzzyEqual(d1xy, config.getNH_MASS(1), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getCO_MASS(1), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getNH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getCO_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getNH_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d1xy, config.getCO_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d2xy, config.getNH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d2xy, config.getCO_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d2yx, config.getNH_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d2yx, config.getCO_MASS(2), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d3xy, config.getNH_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d3xy, config.getCO_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d3yx, config.getNH_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d3yx, config.getCO_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d4xy, config.getNH_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d4xy, config.getCO_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d4yx, config.getNH_MASS(3), config.getErrorTolerance()) || MathUtils.fuzzyEqual(d4yx, config.getCO_MASS(3), config.getErrorTolerance())) {
            ++F4;
        }
        return F4;
    }

    public int firstAminoAcidDistanceScore(double x, PeakList peaklist, ScoringConfiguration config) {
        int peaklistScore = 0;
        for (Peak y : peaklist.getPeakList()) {
            peaklistScore += Score.firstAminoAcidDistanceScore(x, y.getMz(), config);
        }
        return peaklistScore;
    }

    public double calculateAggregatedScore(double xMz, double yMz, List<Peak> isotopicClusterOfPeakX) {
        return this.config.getF1() * (double)Score.firstAminoAcidDistanceScore(xMz, yMz, this.config) + this.config.getF2() * (double)Score.secondComplementaryMassScore(xMz, yMz, this.peptidMassValue, this.chargeValue, isotopicClusterOfPeakX, this.config) + this.config.getF3() * (double)Score.thirdSideChainLossScore(xMz, yMz, this.config) + this.config.getF4() * (double)Score.fourthSupportiveAZIonsScore(xMz, yMz, this.config);
    }

    public static class Range {
        double min;
        double max;

        Range(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public boolean in(double value) {
            return this.min < value && value < this.max;
        }
    }
}

