% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleSim.R
\name{SingleSim.object}
\alias{SingleSim.object}
\alias{print.SingleSim}
\alias{summary.SingleSim}
\title{SingleSim Object}
\arguments{
\item{data}{The data frame, one row per subject containing (at least) the following columns
Id, arm, censored.time, observed.events and actual.events}

\item{event.times}{A list of event times. event.times[[1]] is a list of event times for subject with Id 1
The length of event.times[[1]] = the number of observed events of subject with Id 1}

\item{status}{Either "complete", "dropout" or "imputed" denoting the status of the data set.}

\item{subject.rates}{A vector of the specific rates used for the Poisson process for subjects when generating the data}

\item{dropout.mechanism}{If status is not "complete" then this contains the \code{DropoutMechanism} object
used to perform the subject dropout. See \code{\link{DropoutMechanism.object}}.}

\item{impute.mechanism}{If the status is "imputed" then this contains the \code{ImputeMechanism} object
used to perform the imputation. See \code{\link{ImputeMechanism.object}}}

\item{study.time}{The study follow up period (see \code{SimulateComplete})}

\item{event.rates}{The control/active event rates (see \code{SimulateComplete}), if data set was 
generated without using these (e.g. the dejaData argument was used) then this is set to NULL}

\item{dispersions}{The control/active dispersion rates (see \code{SimulateComplete})}
}
\description{
A class containing the data for a single simulation. Depending on the value
of \code{status}, this may be a complete data set, a set including subject dropouts
or a data set after multiple imputation  
  
\code{print.SingleSim} and \code{summary.SingleSim} methods are defined.
}
\section{Structure}{
 The above components must be included in
a SingleSim Object
}

