% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-functions.R
\name{cow_index}
\alias{cow_index}
\title{CoW States Index}
\usage{
cow_index()
}
\value{
A \code{data.frame} of annual CoW states.
}
\description{
Create an annual index of valid Correlates of War Nations States.
}
\details{
This function generates a dataset to be used for indexing
country-year datasets against the validated CoW states membership. In
short, it will permit the user to quickly drop observations from
country/territory-year data that although they are commonly included in a
variety of political/geographical datasets, these nations or territories
may be disputed (Palestine, Kosovo pre 2008), have a parent nation (Puerto
Rico), or have other peculiarities that do not align with international
standards (CoW, G&W, WDI, IMF).

This is built off of the \code{states} packages, which matched the official
Correlates of War record at the time of publishing.
}
\examples{

cow_index<-demcon::cow_index()

}
