% Generated by roxygen2 (4.0.1): do not edit by hand
\name{rotate_DendSer}
\alias{rotate_DendSer}
\title{Rotates dend based on DendSer}
\usage{
rotate_DendSer(dend, ser_weight, ...)
}
\arguments{
\item{dend}{An object of class dendrogram}

\item{ser_weight}{Used by cost function to evaluate
 ordering. For cost=costLS, this is a vector of
  object weights. Otherwise is a dist or symmetric matrix.
passed to \link{DendSer.dendrogram} and from
there to \link[DendSer]{DendSer}.

If it is missing, the cophenetic distance is used instead.}

\item{...}{parameters passed to \link[DendSer]{DendSer}}
}
\value{
Numeric vector giving an optimal dendrogram order
}
\description{
Rotates a dendrogram based on its seriation

The function tries to turn the dend into hclust using
\link{DendSer.dendrogram} (based on \link[DendSer]{DendSer})

Also, if a distance matrix is missing, it will try
to use the \link{cophenetic} distance.
}
\examples{
\dontrun{
library(DendSer) # already used from within the function
dend <- USArrests[1:4,] \%>\% dist \%>\% hclust("ave") \%>\% as.dendrogram
DendSer.dendrogram(dend)

tanglegram(dend, rotate_DendSer(dend))

}
}
\seealso{
\code{\link[DendSer]{DendSer}}, \link{DendSer.dendrogram} ,
\link{untangle_DendSer}, \link{rotate_DendSer}
}

