% Generated by roxygen2 (4.0.2): do not edit by hand
\name{distinct_edges}
\alias{distinct_edges}
\title{Finds the edges present in the first tree but not in the second}
\source{
A \link{dendrogram} implementation for \link[distory]{distinct.edges} from the {distory} package
}
\usage{
distinct_edges(x, y, ...)
}
\arguments{
\item{x}{a dendrogram to find unique edges in}

\item{y}{a dendrogram to compare with}

\item{...}{Ignored.}
}
\value{
A numeric vector of edge ids for the first tree (x) that are not present in the second tree (y).
}
\description{
Finds the edges present in the first tree but not in the second
}
\examples{
x <- 1:5 \%>\% dist \%>\% hclust \%>\% as.dendrogram
y <- set(x, "labels", 5:1)
distinct_edges(x, y)
distinct_edges(y, x)
dend_diff(x, y)
}
\seealso{
\link{distinct_edges}, \link{highlight_distinct_edges},
\link{dist.dendlist}, \link{tanglegram}
\link[distory]{distinct.edges}
}

