% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{dr.histogram}
\alias{dr.histogram}
\alias{plot.ulsif}
\alias{plot.kliep}
\alias{plot.kmm}
\alias{plot.spectral}
\alias{plot.lhss}
\alias{plot.naivedensityratio}
\title{A histogram of density ratio estimates}
\usage{
dr.histogram(
  x,
  samples = "both",
  logscale = TRUE,
  binwidth = NULL,
  bins = NULL,
  tol = 0.01,
  ...
)

\method{plot}{ulsif}(
  x,
  samples = "both",
  logscale = TRUE,
  binwidth = NULL,
  bins = NULL,
  tol = 0.01,
  ...
)

\method{plot}{kliep}(
  x,
  samples = "both",
  logscale = TRUE,
  binwidth = NULL,
  bins = NULL,
  tol = 0.01,
  ...
)

\method{plot}{kmm}(
  x,
  samples = "both",
  logscale = TRUE,
  binwidth = NULL,
  bins = NULL,
  tol = 0.01,
  ...
)

\method{plot}{spectral}(
  x,
  samples = "both",
  logscale = TRUE,
  binwidth = NULL,
  bins = NULL,
  tol = 0.01,
  ...
)

\method{plot}{lhss}(
  x,
  samples = "both",
  logscale = TRUE,
  binwidth = NULL,
  bins = NULL,
  tol = 0.01,
  ...
)

\method{plot}{naivedensityratio}(
  x,
  samples = "both",
  logscale = TRUE,
  binwidth = NULL,
  bins = NULL,
  tol = 0.01,
  ...
)
}
\arguments{
\item{x}{Density ratio object created with e.g., \code{\link[=kliep]{kliep()}}, \code{\link[=ulsif]{ulsif()}},
or \code{\link[=naive]{naive()}}}

\item{samples}{Character string indicating whether to plot the 'numerator',
'denominator', or 'both' samples. Default is 'both'.}

\item{logscale}{Logical indicating whether to plot the density ratio
estimates on a log scale. Default is TRUE.}

\item{binwidth}{Numeric indicating the width of the bins, passed on to
\code{ggplot2}.}

\item{bins}{Numeric indicating the number of bins. Overriden by binwidth, and
passed on to \code{ggplot2}.}

\item{tol}{Numeric indicating the tolerance: values below this value will be set to the tolerance value, for legibility of the plots}

\item{...}{Additional arguments passed on to \code{predict()}.}
}
\value{
A histogram of density ratio estimates.

A histogram of density ratio estimates.

A histogram of density ratio estimates.

A histogram of density ratio estimates.

A histogram of density ratio estimates.

A histogram of density ratio estimates.

A histogram of density ratio estimates.
}
\description{
Creates a histogram of the density ratio estimates. Useful to understand the
distribution of estimated density ratios in each sample, or compare it among
samples. It is the default plotting method for density ratio objects.
}
\seealso{
\code{\link{ulsif}} for example usage

\code{\link{kliep}} for example usage

\code{\link{kmm}} for example usage

\code{\link{spectral}} for example usage

\code{\link{lhss}} for example usage

\code{\link{naive}} for example usage
}
