% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemiParametricCopulawithoutCovariates.R
\name{Likelihood.Profile.Solve}
\alias{Likelihood.Profile.Solve}
\title{Solve the profiled likelihood function}
\usage{
Likelihood.Profile.Solve(
  yobs,
  delta,
  copfam,
  margins,
  ktau.init,
  parapar.init,
  cure,
  curerate.init,
  constraints,
  maxit,
  eps
)
}
\arguments{
\item{yobs}{a numeric vector that indicated the observed survival times.}

\item{delta}{a numeric vector that stores the right-censoring indicators.}

\item{copfam}{a character string that specifies the copula family.}

\item{margins}{a list used to define the distribution structures of both the survival and censoring margins.}

\item{ktau.init}{initial value of Kendall's tau.}

\item{parapar.init}{initial value of parametric parameters.}

\item{cure}{a logical value that indicates whether the existence of a cured fraction should be considered.}

\item{curerate.init}{initial value of cure rate.}

\item{constraints}{constraints of parameters.}

\item{maxit}{a positive integer that denotes the maximum iteration number in optimization.}

\item{eps}{a positive small numeric value that denotes the tolerance for convergence.}
}
\description{
Solve the profiled likelihood function
}
