% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{gridSearch}
\alias{gridSearch}
\title{Grid search algorithm for finding the identified set}
\usage{
gridSearch(
  dir,
  test.fun,
  hyperparams,
  evaluations = NULL,
  time.run.duration = FALSE,
  verbose = 0,
  picturose = FALSE
)
}
\arguments{
\item{dir}{Search direction.}

\item{test.fun}{The test function to be inverted in order to obtain the
identified set. It should take a scalar parameter as argument (i.e. the
specified value of a component of the full parameter vector) and return a
list with named elements \code{list(theta, t.stat, crit.val)}, where
\code{theta} is the scalar value that was tested, \code{t.stat} is the value
of the test statistic and \code{crit.val} is the critical value to be used in
determining whether to reject or not reject.}

\item{hyperparams}{List of hyperparameters.}

\item{evaluations}{Matrix of already evaluated points, of which at least one
is feasible. When \code{evaluations = NULL} (default), the initial feasible
point search will be executed first.}

\item{time.run.duration}{Boolean value indicating whether to time each step
in the EAM algorithm. Requires \code{chronometer.R}. Default is
\code{time.run.duration = FALSE}.}

\item{verbose}{Boolean value indicating whether or not to print run time
updates to the console. Default is \code{verbose = FALSE}.}

\item{picturose}{Boolean value indicating whether or not to visualize the
identified set search. Default is \code{FALSE}.}
}
\value{
List containing the evaluations of the test statistic and critical
values, convergence information, and run times.
}
\description{
This function implements the gridsearch and binary search
algorithms used to compute the roots of the violation curve and hence in
estimating the identified intervals.
}
