% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_interact.R
\name{summary_interact}
\alias{summary_interact}
\title{summary_interact}
\usage{
summary_interact(
  model,
  ref,
  discrete,
  ref_min = NULL,
  ref_max = NULL,
  level = NULL,
  ...,
  digits = 3L,
  p = FALSE
)
}
\arguments{
\item{model}{A model from \code{\link[rms]{lrm}}}

\item{ref}{A continuous variable for which we are interested in the
estimation of the OR for the various level of interaction with a discrete
variable interacting with it}

\item{discrete}{The discrete interacting variable}

\item{ref_min}{Denominator continuous level for the Odds Ratio
(i.e., the reference level), if NULL (the default)}

\item{ref_max}{Numerator continuous level for the Odds Ratio
(i.e., the target level)}

\item{level}{A character vector of levels to show. Default (NULL) means to
show all the possible levels for the discrete variable}

\item{...}{for possible future development}

\item{digits}{number of significant digits to print. Default is 3

Note: the \code{\link[rms]{datadist}} has to be defined for the data used in
 the model}

\item{p}{do you want also the P-value (default = FALSE)}
}
\value{
A data frame
}
\description{
summary_interact
}
\examples{
\donttest{
  library(rms)
  options(datadist = "dd")

  data("transplant")

  transplant <- transplant[
    transplant[["event"]] != "censored", ,
    drop = FALSE
  ]
  dd <- datadist(transplant)

  lrm_mod <- lrm(event ~ rcs(age, 3) * (sex + abo) + rcs(year, 3),
    data = transplant
  )

  lrm_mod
  summary(lrm_mod)
  summary_interact(lrm_mod, age, sex)
  summary_interact(lrm_mod, age, sex, ref_min = 60, ref_max = 80)
  summary_interact(lrm_mod, age, sex,
    ref_min = 60, ref_max = 80, digits = 5L
  )

  summary_interact(lrm_mod, age, abo)
  summary_interact(lrm_mod, age, abo, level = c("A", "AB"))
  summary_interact(lrm_mod, age, abo, level = c("A", "AB"), p = TRUE)
}
}
