/* 
moving lystig into C code 
*/

#include <R.h>	
#include <Rinternals.h>

/* 
 * Log likelihood computation according to Lystig & Hughes (2002).  This
 * is very similar to the Forward part of the Forward-Backward algorithm
 * but admits of easy computation of the gradients of parameters and the
 * observed information.  This version of the routine only computes the
 * likelihood though.
 * 
 * NOTE THE CHANGE IN FROM ROW TO COLUMN SUCH THAT TRANSPOSING A IS NOT NECCESSARY ANYMORE 
 * IN COMPUTING ALPHA AND BETA BUT IS NOW NECCESSARY IN COMPUTING XI
 * A = K*K matrix with transition probabilities, from column to row !!!!!!!
 * change to T*K*K
 * 
 * B = T*K matrix with elements ab_{ij} = P(y_i|s_j)
 * init = K vector with initial probabilities !!!OR!!! K*length(ntimes) matrix with initial probs per case
 */

/* 
 * RETURNS: 'sca'le factors, recurrent variables 'phi', loglikelihood
 */




SEXP mkans(double x) {
	SEXP ans;
	PROTECT(ans = allocVector(REALSXP, 1));
	REAL(ans)[0] = x;
	UNPROTECT(1);
	return ans;
}

/* , SEXP A, SEXP B, SEXP, SEXP ntimes, SEXP stationary */

SEXP lystig(SEXP init, SEXP ntimes) {
	
	int nt=INTEGER(ntimes)[0];
	
	Rprintf("nt: %d \n", nt);
	
	double loglike=0.0;
	
	Rprintf("Init ans: %f \n",loglike);
	
	for(int i=0; i<nt; i++) {
		loglike+=1;
	}
		
	Rprintf("End ans: %f \n",loglike);
	
	return(mkans(loglike));

}



/* 
 * for(case in 1:lt) { # multiple cases
 *     phi[bt[case],] <- init[case,]*B[bt[case],] # initialize
 *     sca[bt[case]] <- 1/sum(phi[bt[case],])
 *     if(ntimes[case]>1) {
 *         for(i in (bt[case]+1):et[case]) {
 *             if(stationary) phi[i,] <- (A[1,,]%*%phi[i-1,])*B[i,]
 *             else phi[i,] <- (A[i-1,,]%*%phi[i-1,])*B[i,]
 *             phi[i,] <- sca[i-1]*phi[i,]
 *             sca[i] <- 1/sum(phi[i,])
 *         }
 *     }
 * }
 *         
 * logLike=-sum(log(sca))
 * return(list(phi=phi,sca=sca,logLike=logLike))
 */
