% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asianmontecarlo.R
\name{arithasianmc}
\alias{arithasianmc}
\title{Asian Monte Carlo option pricing}
\usage{
arithasianmc(s, k, v, r, tt, d, m, numsim=1000, printsds=FALSE)
}
\arguments{
\item{s}{Price of underlying asset}

\item{k}{Strike price of the option. In the case of average strike
options, \code{k/s} is the multiplier for the average}

\item{v}{Volatility of the underlygin asset price, defined as the
annualized standard deviation of the continuously-compounded
return}

\item{r}{Annual continuously-compounded risk-free interest rate}

\item{tt}{Time to maturity in years}

\item{d}{Dividend yield, annualized, continuously-compounded}

\item{m}{Number of prices in the average calculation}

\item{numsim}{Number of Monte Carlo iterations}

\item{printsds}{Print standard deviation for the particular Monte
Carlo calculation}
}
\value{
Array of arithmetic average option prices, along with
    vanilla European option prices implied by the the
    simulation. Optionally returns Monte Carlo standard deviations.
}
\description{
Monte Carlo pricing calculations for European Asian
    options.  \code{arithasianmc} and \code{geomasianmc} compute
    Monte Carlo prices for the full range of average price and
    average strike call and puts computes prices of a complete
    assortment of Arithmetic Asian options (average price call and
    put and average strike call and put)

Arithmetic average Asian option prices
}
\examples{
s=40; k=40; v=0.30; r=0.08; tt=0.25; d=0; m=3; numsim=1e04
arithasianmc(s, k, v, r, tt, d, m, numsim, printsds=TRUE)
}
\seealso{
Other Asian: \code{\link{arithavgpricecv}},
  \code{\link{asiangeomavg}}, \code{\link{geomasianmc}}
}

