% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bins_table.R
\name{bins_table}
\alias{bins_table}
\title{Bins table}
\usage{
bins_table(
  data,
  x,
  cols = "n",
  vals = "x",
  weights = NULL,
  breaks = NULL,
  xfirst = NULL,
  xlast = NULL,
  right = NULL,
  total = FALSE,
  wlast = NULL
)
}
\arguments{
\item{data}{un tibble}

\item{x}{a numerical series (either numerical values or numerical
classes)}

\item{cols}{a string containing \code{n} for counts, \code{f} pour
frequencies and \code{p} for percentages ; the cumulative series are
obtained using the same letters in upper caps. Compared to
\code{freq_table}, densities can be computed using the letter \code{d}.}

\item{vals}{a character containing letters indicating the values of
the variable that should be returned ; \code{x} for the center of
the class, \code{l} and \code{u} for the lower and upper limit of the
class, \code{a} for the range}

\item{weights}{a series that contain the weights tant enables the
sample to mimic the population}

\item{breaks}{a numerical vector of class limits}

\item{xfirst}{a numeric indicating the value of the center of the
first class}

\item{xlast}{a numeric indicating the center of the last class}

\item{right}{a logical indicating whether classes should be closed
(\code{right = TRUE}) or open (\code{right = FALSE}) on the right}

\item{total}{a logical indicating whether the total should be
returned}

\item{wlast}{if \code{xlast} is not set, the width of the last class
is set to the one of the second to last width times this
parameter}
}
\value{
a tibble containing the specified values of \code{vals} and
\code{cols}
}
\description{
Compute the counts for each class of  a numerical variable
}
\examples{

# in table padova, price is a numeric variable, a vector of breaks should be provided
padova \%>\% bins_table(price, breaks = c(50, 100, 150, 200, 250, 300, 350, 400),
                      right = TRUE)
padova \%>\% bins_table(price, breaks = c(50, 100, 150, 200, 250, 300, 350, 400),
                      right = TRUE, cols = "fd", vals = "xa")
# in table wages, wage  is a factor that represents the classes
wages \%>\% bins_table(wage, "d")
# a breaks argument is provided to reduce the number of classes
wages \%>\% bins_table(wage, breaks = c(10, 20, 30, 40, 50))

}
\author{
Yves Croissant
}
