% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bins_table.R
\name{bins_table.methods}
\alias{bins_table.methods}
\alias{mean.bins_table}
\alias{variance.bins_table}
\alias{stdev.bins_table}
\alias{madev.bins_table}
\alias{modval.bins_table}
\alias{quantile.bins_table}
\alias{median.bins_table}
\alias{medial.bins_table}
\alias{gini}
\title{Methods for bins_table objects}
\usage{
\method{mean}{bins_table}(x, ...)

\method{variance}{bins_table}(x, ...)

\method{stdev}{bins_table}(x, ...)

\method{madev}{bins_table}(x, center = c("median", "mean"), ...)

\method{modval}{bins_table}(x, ...)

\method{quantile}{bins_table}(x, y = c("value", "mass"), probs = c(0.25, 0.5, 0.75), ...)

\method{median}{bins_table}(x, ..., y = c("value", "mass"))

\method{medial}{bins_table}(x, ...)

gini(x)
}
\arguments{
\item{x}{a bins_table object,}

\item{...}{further arguments}

\item{center}{for the \code{madev} method, this can equal \code{"median"}
(the default) or \code{"mean"}}

\item{y}{for the quantile method, one of \code{"value"} or \code{"mass"}}

\item{probs}{the probabilities for which the quantiles have to be
computed}
}
\value{
a  numeric
}
\description{
Functions and methods to compute the median, the mean, the mode,
the medial and quantiles for bins_table objects
}
\examples{
z <- wages \%>\% bins_table(wage)
z \%>\% median
z \%>\% medial
z \%>\% modval
z \%>\% quantile(probs = c(0.25, 0.5, 0.75))
z \%>\% quantile(y = "mass", probs = c(0.25, 0.5, 0.75))
}
\author{
Yves Croissant
}
