% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/d.overall.R
\name{d.overall}
\alias{d.overall}
\title{Combine individual desirabilities}
\usage{
d.overall(..., weights = NULL)
}
\arguments{
\item{...}{Any number of individual desirabilities.}

\item{weights}{Allows some desirabilities to count for more in the overall
calculation. Defaults to equal weighting.}
}
\value{
Numeric vector of desirability values.
}
\description{
Combines any number of desirability values into an overall
desirability.
}
\details{
This function takes any number of individual desirabilities and
combines them with a weighted geometric mean to give an overall
desirability. The weights should be chosen to reflect the importance of the
variables. The values of the weights do not matter, only their relative
differences. Therefore weights of 4, 2, 1 are the same as 1, 0.5, 0.25. In
both cases the second weight is half of the first, and the third weight is a
quarter of the first.
}
\examples{
set.seed(1)
x1 <- rnorm(1000, mean=100, sd =5) # generate data
x2 <- rnorm(1000, mean=100, sd =5)

d1 <- d.high(x1, cut1=90, cut2=110, scale=1)
d2 <- d.low(x2, cut1=90, cut2=110, scale=1)

D <- d.overall(d1, d2, weights=c(1, 0.5))
plot(rev(sort(D)), type="l")
}

